jQuery(document).ready(function($){
	
	"use strict";

	// sf menu
	jQuery('ul.sf-menu').superfish({
		animation:     {height:'show'},   
		animationOut:  {height:'hide'}, 
		speed:         'fast',           
		speedOut:      'fast', 
		delay:         800,
		pathClass:	'current'           
	});
	jQuery('ul.sf-menu li').each(function() {
        var mega = jQuery(this).find('.sf-mega');
        if ( mega.length ) {
            jQuery(this).addClass('megamenu');
        }
    });

    // Toggle Submenu Fuction
    jQuery.fn.toggle = function( fn, fn2 ) {
      if ( !jQuery.isFunction( fn ) || !jQuery.isFunction( fn2 ) ) {
        return oldToggle.apply( this, arguments );
      }
      var args = arguments,
      guid = fn.guid || jQuery.guid++,
      i = 0,
      toggler = function( event ) {
        var lastToggle = ( jQuery._data( this, "lastToggle" + fn.guid ) || 0 ) % i;
        jQuery._data( this, "lastToggle" + fn.guid, lastToggle + 1 );
        event.preventDefault();
        return args[ lastToggle ].apply( this, arguments ) || false;
      };
      toggler.guid = guid;
      while ( i < args.length ) {
        args[ i++ ].guid = guid;
      }
      return this.click( toggler );
    };

    // Responsive Mobile Menu
    var navlist = jQuery('.site-menu > nav ul').clone();
    var submenu = '<span class="submenu"><i class="fa fa-angle-double-down"></i></span>';
    navlist.removeClass().addClass('mobile-menu');
    navlist.find('ul').removeAttr('style');
    navlist.find('li:has(> ul) > a').after(submenu);;
    navlist.find('.submenu').toggle(function(){
        jQuery(this).parent().addClass('over').find('>ul').slideDown(200);
    },function(){
        jQuery(this).parent().removeClass('over').find('>ul').slideUp(200);
    });
    jQuery('.sb-slidebar .sb-menu-trigger').after(navlist[0]);


    // Section
    jQuery('.section').each(function(){
        var bg = jQuery(this);

        if(bg.data('bg')){
            bg.css('background-image','url('+bg.data('bg')+')');
        }
        if(bg.data('bgcolor')){
            bg.css('background-color',bg.data('bgcolor'));
            bg.css('border-top-color',bg.data('bgcolor'));
        }
        if(bg.data('bgmark')){
            bg.append('<div class="section-bgwrap" />');
            bg.find('.section-bgwrap').css('background-color',bg.data('bgmark'));
        }

        bg.css('width',bg.data('width'));
        bg.css('min-height',bg.data('minheight'));
        bg.css('margin',bg.data('margin'));
        bg.css('padding',bg.data('padding'));
    });

    // Slider Item Content
    jQuery('.slider-item-content').each(function(){
        var a = jQuery(this);
        if(a.data('top')){
            a.css('top',a.data('top'));
        }
        if(a.data('bottom')){
            a.css('bottom',a.data('bottom'));
        }
        if(a.data('left')){
            a.css('left',a.data('left'));
        }
        if(a.data('right')){
            a.css('right',a.data('right'));
        }
    });

    // Elements
    jQuery('.element').each(function(){
        var elm = jQuery(this);
        elm.css('margin',elm.data('margin'));
        elm.css('padding',elm.data('padding'));
    });

   
    function erovo_hover() {
        // Masonry
        if ( $.isFunction($.fn.masonry) ) {

            var container = jQuery('#masonry');
            container.imagesLoaded(function(){
              container.masonry();
            });
        }

        jQuery('.iconbox-large').each(function() {
            var iconheight = jQuery(this).find('.icon-content-wrap .icon').outerHeight();
            jQuery(this).hover(function() {
                jQuery(this).find('.icon-content-wrap .icon').stop().animate({'margin-top' : iconheight*-1-22, 'opacity' : 0}, 400, 'jswing');
            }, function(){
                jQuery(this).find('.icon-content-wrap .icon').stop().animate({'margin-top' : 0, 'opacity' : 1}, 200, 'jswing');
            });
        });

        jQuery('.product-item').each(function() {
            var a = jQuery(this).find('.product-image').outerHeight(true);
            jQuery(this).height(a);
            jQuery(this).hover(function() {
                jQuery(this).find('.product-image').stop().animate({'margin-top' : -a}, 400, 'jswing');
            }, function(){
                jQuery(this).find('.product-image').stop().animate({'margin-top' : 0}, 200, 'jswing');
            });
        });

       
        // Member
        jQuery('.member-item').each(function(){
            var cw = jQuery(this).find('.member-content .member-name').height();
            var ca = jQuery(this).find('.member-content').outerHeight();
            jQuery(this).find('.member-content').height(cw);
            jQuery(this).hover(function() {
                jQuery(this).find('.member-content').stop().animate({'height' : ca}, 320, 'easeInSine');
                jQuery('body').find('.member-item').addClass('inactive');
                jQuery(this).removeClass('inactive').addClass('active');
            }, function(){
                jQuery(this).find('.member-content').stop().animate({'height' : cw+40}, 320, 'easeOutSine');
                jQuery('body').find('.member-item').removeClass('inactive');
                jQuery(this).removeClass('active');
            });
        });

        equalHeight(jQuery('.iconbox-large'));
        jQuery('.row').each(function(){
            equalHeight(jQuery(this).find('.content-height'));
        });

//        jQuery('.main-header').affix({
//            offset: {
//                top: jQuery('#header').outerHeight() - jQuery('#header .main-header').outerHeight(),
//                bottom: function () {
//                    return (this.bottom = jQuery('#footer').outerHeight(true))
//                }
//            }
//        });
    }

    // Eqal Height
    function equalHeight(group) {
        var tallest = 0;
        group.each(function() {
            var thisHeight = jQuery(this).height();
            if(thisHeight > tallest) {
                tallest = thisHeight;
            }
        });
        group.height(tallest);
    }

    jQuery(window).load(function(){
        var resizeTimer;
        jQuery(window).resize(function() {
          clearTimeout(resizeTimer);
          resizeTimer = setTimeout(erovo_hover, 0);
        }).resize();
    });

    // Tooltips
    jQuery('*[data-toggle="tooltip"]').tooltip();

    
       // FitVids
    jQuery(".entry-media").fitVids();

    // Mag Popup
    jQuery('.image-popup').magnificPopup({
        type: 'image',
        closeOnContentClick: true,
        image: {
            verticalFit: true
        }
    });

    // Parallax
    jQuery('.bg').parallax("50%", 0.4);

    

  
    // Progress Bar
    setTimeout(function(){
        jQuery('.progress .progress-bar').each(function() {
            var me = jQuery(this);
            var perc = me.data('percentage');
            var bgcolor = me.data('bgcolor');
            var current_perc = 0;
            var progress = setInterval(function() {
                if (current_perc>=perc) {
                    clearInterval(progress);
                } else {
                    current_perc +=1;
                    me.css('width', (current_perc)+'%');
                    me.css('background-color', (bgcolor))
                }
            }, 10);
        });
    },10);

    
    // Animate Text
    jQuery('.atext').Morphext({
        animation: 'flipInX',
        separator: ',',
    });

//    // Header Animate
//    jQuery('.nt-title').newsTicker({
//        row_height: 35,
//        max_rows: 1,
//        duration: 2000,
//        pauseOnHover: 0
//    });

    

    // Button
    jQuery('.button.hover,.button.stroke').each(function() {
        jQuery(this).wrapInner( "<span></span>");
    });

  
    
});